/*
 * disman.h
 *
 * Common main function for simple disassemblers
 */

#include <common/types.h>
#include <stdio.h>


int disassemble_instr(u8 *data, long address);

void usage(char *progname)
{
    printf("%s <filename> <offset> <base> <length>\n", progname);
}

int main(int argc, char *argv[])
{
    FILE *file;
    long offset;
    long base;
    long length;
    long position;
    long result;
    u8 *buffer;
    
    if (argc != 5) {
	usage(argv[0]);
	return -1;
    }

    offset = strtol(argv[2], NULL, 0);
    base = strtol(argv[3], NULL, 0);
    length = strtol(argv[4], NULL, 0);

    file = fopen(argv[1], "rb");
    fseek(file, offset, SEEK_SET);
    buffer = malloc(length);
    fread(buffer, 1, length, file);

    for (position = 0; position < length; ) {
	result = disassemble_instr(buffer + position, base + position);
	if (!result) return -1;
	position += result;
    }
    
    return 0;
}

/* EOF */
